---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：56-メール通知（HTML - Zurb 2）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Gmailのstyleタグ無視に関する記述**：外部ドキュメントの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/body.html.twig`（Zurb 2 HTMLテンプレート、67行）
- E-02: `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php`（NotificationEmailクラス、281行）
- E-03: `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/local.css`（通知固有CSS、20行）
- E-04: `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/main.css`（ベースCSS、1786行）
- E-05: `src/Symfony/Bridge/Twig/Resources/views/Email/zurb_2/notification/content_markdown.html.twig`（Markdownテンプレート、1行）
- E-06: `src/Symfony/Bridge/Twig/Resources/views/Email/default/notification/body.html.twig`（デフォルトテーマ、1行）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | inky_to_htmlとinline_cssフィルタを使用する | E-01 行1 `{% apply inky_to_html\|inline_css %}` | ○ |
| C-02 | source()関数でmain.cssとlocal.cssを読み込む | E-01 行6-7 `{{ source('@email/zurb_2/main.css') }}` `{{ source('@email/zurb_2/notification/local.css') }}` | ○ |
| C-03 | 重要度に応じてbody_alert/body_warning/body_defaultを切替 | E-01 行14 | ○ |
| C-04 | body_alertの色が#ec5840（赤）、8pxボーダー | E-03 行10 `border-top: 8px solid #ec5840` | ○ |
| C-05 | body_warningの色が#ffae00（黄）、8pxボーダー | E-03 行14 `border-top: 8px solid #ffae00` | ○ |
| C-06 | body_defaultの色が#aaaaaa（グレー）、8pxボーダー | E-03 行18 `border-top: 8px solid #aaaaaa` | ○ |
| C-07 | importance != null時に重要度ラベルを大文字で表示 | E-01 行19 `{% if importance is not null %}<small><strong>{{ importance\|upper }}</strong></small>{% endif %}` | ○ |
| C-08 | email.subjectをp.leadタグで表示 | E-01 行21 `<p class="lead">{{ email.subject }}</p>` | ○ |
| C-09 | Markdown時にcontent_markdown.html.twigをインクルード | E-01 行27 `{{ include('@email/zurb_2/notification/content_markdown.html.twig') }}` | ○ |
| C-10 | content_markdown.html.twigでmarkdown_to_htmlフィルタ使用 | E-05 行1 `{{ content\|markdown_to_html }}` | ○ |
| C-11 | raw時にcontent\|raw、それ以外でcontent\|nl2br | E-01 行29 `{{ raw ? content\|raw : content\|nl2br }}` | ○ |
| C-12 | action_url指定時にInkyボタンを表示 | E-01 行34-37 `{% if action_url %}<button href="{{ action_url }}">{{ action_text }}</button>{% endif %}` | ○ |
| C-13 | exception時にスタックトレース添付通知を表示 | E-01 行41-44 | ○ |
| C-14 | footer_text指定時にセカンダリラッパーでフッターを表示 | E-01 行52-60 `{% if footer_text is defined and footer_text is not null %}` | ○ |
| C-15 | 7つのTwigブロック（style, lead, content, action, exception, footer, footer_content） | E-01 ブロック定義の確認 | ○ |
| C-16 | デフォルトテーマが本テンプレートを継承 | E-06 行1 `{% extends '@email/zurb_2/notification/body.html.twig' %}` | ○ |
| C-17 | Foundation for Emails 2ベースCSSはMITライセンス | E-04 行2-3 `Copyright (c) 2017 ZURB, inc. -- MIT License` | ○ |
| C-18 | main.cssが1786行である | E-04 実行結果（1786行確認済み） | ○ |
| C-19 | レスポンシブ対応が596pxブレークポイント | E-04 行862 `@media only screen and (max-width: 596px)` | ○ |
| C-20 | GmailがstyleタグをCSS無視するためインライン化が必須 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: Gmailのstyleタグ処理に関する記述は一般的な知識であるが、本プロジェクト内に根拠ドキュメントが存在しない
  - 候補：Gmail開発者ドキュメント / Email on Acid等のメールテスト文献 / Foundation for Emails公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の大部分がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Inkyマークアップの各タグ（container、row、columns、button、spacer、wrapper）の説明が正確か確認
- [ ] CSS読み込みの仕組み（source関数）の説明が正確か確認
- [ ] 7つのTwigブロックが全て網羅されているか確認
